% -----------------
% Problema de canal
% -----------------
% Queremos diseñar un canal para transporte de agua, revestido de hormigón con sección trapezoidal, con inclinación de 50º
% El área de nuestra sección debe ser 6 m² para poder llevar el caudal calculado. Si el metro lineal de hormigón colocado en obra cuesta 30€/m
% ¿Cuál es la sección óptima para obtener el mejor precio? 
%
% --- DATOS ---
% Perimetro sección: 2*l+b
% Sección 6 m2
% Area: b+l*cos(50)
% 6=b+l*cos(50)
% 
% --- SOLUCION ---
% Damos valores a b, obtenemos l, calculamos precio
A=6;
b=0:0.1:5;
l=A./(b./cos(50*pi/180));
peri=2*l+b;
precio=peri*30;
%b',l', peri', precio'

for j=1:length(b)
   fprintf('%s %1.3f %s %1.3f %s %1.3f %s %1.2f \n','b:', b(j),'l:', l(j), 'peri:', peri(j),'euros:', precio(j))
end

% Dibujamos la relación b - precio
plot(b,precio)
pause;
% Como los primeros valores distorsionan mucho no los tomamos para la gráfica
plot(b(15:end),precio(15:end))
pause;
% Damos un poco de formato y guardamos esta última gráfica
title('Base (b) frente a precio (euros)');
xlabel('base (b) [m]');
ylabel('precio [euros]'); 
print -dpng 'canal-b-precio.png';
